/*
 * Private structs for linktest
 */

struct lt_xbar {
  int *bad;
  int *tested;
};
#define LT_XBAR(P) ((struct lt_xbar *)(P))

enum {
  LT_RES_OK,
  LT_RES_NO_LINK,
  LT_RES_MARGINAL_LINK,
  LT_RES_SLOW_LINK
};

#define DELTA_TO_ROUTE(D) (((D)&0x3F) | 0x80)
#define ROUTE_TO_DELTA(R) (((unsigned char)(R)>0x90)?((R)-0xC0):((R)-0x80))

#define LF_ERROR(S)							\
 do {									\
   perror(S);								\
   goto except;								\
 } while (0)

/*
 * prototypes
 */
void check_all_links(struct lf_fabric *fp, struct lf_nic *np, int hport);
struct lf_host *find_self(struct lf_fabric *fp);
void calc_xbar_routes(struct lf_fabric *fp, struct lf_nic *nicp);
